export interface ConfigState {
  // 1. Planung & Fundament
  checkBauantrag: boolean;
  checkKfW: boolean;
  checkSoilReport: boolean;
  checkSurveying: boolean;
  checkCrane: boolean; // Neu: Kranstellung
  fundamentSelect: '0' | 'streifen_ungedaemmt' | 'streifen_gedaemmt' | 'platte_ungedaemmt' | 'platte_gedaemmt';
  fundamentArea: number;

  // 2. Haus & Konstruktion
  areaInput: number;
  // SPLIT WALLS
  wallThicknessExterior: '15' | '17' | '20';
  wallThicknessInterior: '12' | '15' | '20'; // Updated to 20
  
  wallHeight: number;
  roofSelect: 'none' | 'flat' | 'sattel' | 'pult';
  facadeSelect: 'paneele' | 'wpc' | 'putz' | 'wdvs' | 'wood' | 'none';

  // 3. Fenster & Türen
  windowMaterial: 'plastic' | 'alu'; // Neu: Material
  winPano: number;
  winStd: number;
  shutterCount: number;
  doorOut: number;
  doorIn: number;
  glassDoorIn: number;
  glassDoorFrame: 'plastic' | 'alu';

  // 4. Innenausbau
  drywallSelect: 'none' | 'gips' | 'lehm';
  checkCeilingIncluded: boolean; // Neu: Decke mitrechnen?
  paintSelect: 'none' | 'weiss' | 'color';
  floorSelect: 'none' | 'vinyl' | 'laminat' | 'parkett' | 'fliesen';
  checkTrittschall: boolean;
  fireplaceSelect: 'none' | 'wood' | 'pellet' | 'electric'; // NEU: Kamin
  socketCount: number;
  lanCount: number;
  lightStdCount: number;
  lightSpotCount: number;
  smokeCount: number;
  checkFuseBox: boolean;

  // 5. Technik & Sanitär
  heatSelect: 'none' | 'ac' | 'floor_elec' | 'floor_water' | 'pump';
  acCount: number;
  waterType: 'none' | 'boiler' | 'flow';
  waterModel: string;
  ventSelect: '0' | 'decentral' | 'central';
  checkPvPrep: boolean;
  pvSystem: 'none' | '5kw' | '10kw';
  batteryStorage: 'none' | '5kwh' | '10kwh';
  wcCount: number;
  sinkCount: number;
  showerCount: number;
  tubCount: number;
  tapCount: number;

  // 6. Extras
  terraceArea: number;
  garageCount: number;
  checkStairOut: boolean;
  checkStairIn: boolean;
}

export interface PriceResult {
  s1: number;
  s2: number;
  s3: number;
  s4: number;
  s5: number;
  s6: number;
  netto: number;
  tax: number;
  brutto: number;
  wallArea: number; // for info display
  uValue: string;
  energyStandard: string;
  energyScore: number;
}