import React, { useEffect, useState } from 'react';
import { formatCurrency } from '../utils';

interface SectionCardProps {
  number: number;
  title: string;
  price: number;
  children: React.ReactNode;
}

const SectionCard: React.FC<SectionCardProps> = ({ number, title, price, children }) => {
  const [highlight, setHighlight] = useState(false);
  const [prevPrice, setPrevPrice] = useState(price);

  useEffect(() => {
    if (price !== prevPrice) {
      setHighlight(true);
      setPrevPrice(price);
      const timer = setTimeout(() => setHighlight(false), 500);
      return () => clearTimeout(timer);
    }
  }, [price, prevPrice]);

  return (
    <div className="bg-white p-10 rounded-md shadow-card border border-gray-200 transition-all duration-300 hover:shadow-card-hover hover:border-accent hover:-translate-y-0.5">
      <div className="flex justify-between items-center mb-8 pb-4 border-b border-gray-100">
        <div className="text-2xl text-primary flex items-center gap-4 font-serif">
          <div className="bg-primary text-accent w-9 h-9 rounded-full flex items-center justify-center text-lg font-semibold font-sans">
            {number}
          </div>
          {title}
        </div>
        <div className={`font-sans font-semibold text-success bg-[#eefdf5] px-4 py-1.5 rounded-full text-sm transition-transform duration-300 ${highlight ? 'animate-pulse-gold scale-110' : ''}`}>
          {formatCurrency(price)}
        </div>
      </div>
      <div className="flex flex-col gap-8">
        {children}
      </div>
    </div>
  );
};

export default SectionCard;
