import React, { useEffect, useState } from 'react';

const SECTIONS = [
  { id: 'section-1', label: '1. Fundament' },
  { id: 'section-2', label: '2. Haus' },
  { id: 'section-3', label: '3. Fenster' },
  { id: 'section-4', label: '4. Innen' },
  { id: 'section-5', label: '5. Technik' },
  { id: 'section-6', label: '6. Extras' },
];

const Navigation: React.FC = () => {
  const [activeId, setActiveId] = useState('');

  const handleScroll = (id: string) => {
    const el = document.getElementById(id);
    if (el) {
      const offset = 100; // Header offset
      const bodyRect = document.body.getBoundingClientRect().top;
      const elementRect = el.getBoundingClientRect().top;
      const elementPosition = elementRect - bodyRect;
      const offsetPosition = elementPosition - offset;

      window.scrollTo({
        top: offsetPosition,
        behavior: 'smooth'
      });
    }
  };

  useEffect(() => {
    const observer = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) {
            setActiveId(entry.target.id);
          }
        });
      },
      { rootMargin: '-40% 0px -60% 0px' } 
    );

    SECTIONS.forEach(({ id }) => {
      const el = document.getElementById(id);
      if (el) observer.observe(el);
    });

    return () => observer.disconnect();
  }, []);

  return (
    <nav className="sticky top-0 z-40 bg-white/90 backdrop-blur-md border-b border-gray-200 shadow-sm hidden md:block">
      <div className="max-w-[1300px] mx-auto px-5">
        <div className="flex items-center gap-1 overflow-x-auto no-scrollbar py-2">
          {SECTIONS.map((sec) => (
            <button
              key={sec.id}
              onClick={() => handleScroll(sec.id)}
              className={`
                whitespace-nowrap px-4 py-2 text-sm font-medium rounded-full transition-all duration-300
                ${activeId === sec.id 
                  ? 'bg-primary text-white shadow-md' 
                  : 'text-gray-500 hover:text-primary hover:bg-gray-100'}
              `}
            >
              {sec.label}
            </button>
          ))}
        </div>
      </div>
    </nav>
  );
};

export default Navigation;