import React, { useState } from 'react';

interface LeadModalProps {
  isOpen: boolean;
  onClose: () => void;
  onSubmit: (name: string, email: string) => void;
}

const LeadModal: React.FC<LeadModalProps> = ({ isOpen, onClose, onSubmit }) => {
  const [name, setName] = useState('');
  const [email, setEmail] = useState('');

  if (!isOpen) return null;

  const handleSubmit = (e: React.FormEvent) => {
    e.preventDefault();
    onSubmit(name, email);
  };

  return (
    <div className="fixed inset-0 z-[2000] flex justify-center items-center bg-black/70 backdrop-blur-sm">
      <div className="bg-white p-12 rounded-md w-[90%] max-w-[500px] relative border-t-4 border-accent shadow-2xl max-h-[90vh] overflow-y-auto">
        <span 
          onClick={onClose}
          className="absolute right-5 top-4 text-3xl cursor-pointer text-gray-300 hover:text-primary transition-colors"
        >
          &times;
        </span>
        <h2 className="mt-0 text-primary font-serif text-2xl mb-2 font-bold">Ihr Exklusives Angebot</h2>
        <p className="text-[#666] text-sm mb-8 leading-relaxed">
          Bitte hinterlassen Sie Ihre Kontaktdaten. Sie erhalten umgehend das detaillierte Exposé und die Preisaufstellung als PDF.
        </p>
        <form onSubmit={handleSubmit}>
          <div className="mb-5">
            <label className="block font-semibold mb-2 text-xs uppercase tracking-wide text-gray-500">Vollständiger Name</label>
            <input 
              type="text" 
              required 
              placeholder="Ihr Name" 
              value={name}
              onChange={(e) => setName(e.target.value)}
              className="w-full p-3.5 border border-gray-200 rounded-md text-base bg-white text-primary transition-all focus:outline-none focus:border-accent focus:shadow-[0_0_0_4px_rgba(197,160,89,0.15)]"
            />
          </div>
          <div className="mb-8">
            <label className="block font-semibold mb-2 text-xs uppercase tracking-wide text-gray-500">E-Mail Adresse</label>
            <input 
              type="email" 
              required 
              placeholder="name@beispiel.de" 
              value={email}
              onChange={(e) => setEmail(e.target.value)}
              className="w-full p-3.5 border border-gray-200 rounded-md text-base bg-white text-primary transition-all focus:outline-none focus:border-accent focus:shadow-[0_0_0_4px_rgba(197,160,89,0.15)]"
            />
          </div>
          <button 
            type="submit" 
            className="w-full bg-primary text-accent border border-primary p-4 rounded-md text-lg font-semibold cursor-pointer uppercase tracking-widest transition-all hover:bg-accent hover:text-white hover:border-accent hover:-translate-y-0.5 shadow-lg"
          >
            Kostenloses Angebot anfordern
          </button>
        </form>
      </div>
    </div>
  );
};

export default LeadModal;
